<?php
global $mo_MoWpnsUtility,$mmp_dirName;
$setup_dirName = $mmp_dirName.'views'.DIRECTORY_SEPARATOR.'link_tracers.php';
 include $setup_dirName;
 
 ?>
<div class="mo_wpns_setting_layout" id="scan_report_table">
	<?php if(! isset($_GET['view'])){ ?>	
		<h2>Malware Scan Report</h2>
	<?php }else{ ?>
		<h2>Detail Report Of Scan
			<a href="<?php echo esc_url($currenturl) ?>"><b style="float: right; padding-right: 4%">Back To Reports</b></a>
		</h2>
	<?php } ?>
		<hr>
		<div id="scandata">
			<?php 
				include_once $mmp_dirName. 'controllers'.DIRECTORY_SEPARATOR.'malware_scanner'.DIRECTORY_SEPARATOR.'malware_scan_result.php';
				echo mo_mmp_showScanResults();
			?>
		</div>
	</div>

<div class="mo_wpns_setting_layout">
    <h3>Other plugins</h3>
	<hr>
    <div class="blog-card">
        <div class="meta">
            <div class="photo" style="background-image: url(https://ps.w.org/miniorange-penetration-testing-tool/assets/icon-128x128.png)"></div>
        </div>
        <div class="description">
            <h1><a href="https://wordpress.org/plugins/password-policy-manager/">Password Policy Manager | Password Manager</a></h1>
            <p>
            <ul style="list-style-type: circle">
                <li> Users password manager</li>
                <li> Enforce strong password </li>
                <li> Force password change</li>
                <li> One click reset password</li>
				<li> Set password expiry </li>
            </ul>
            </p>
            <div style="float:right;">
                <?php
                $plugin_name = 'miniorange-penetration-testing-tool';
                $install_link = '<a href="' . esc_url( network_admin_url('plugin-install.php?tab=plugin-information&plugin=' . esc_attr($plugin_name) . '&TB_iframe=true&width=600&height=550' ) ) . '" class="thickbox" title="More info about MiniOrange Penetration Testing Tool"><input type="button" class="button button-primary button-large" value="Install"/></a>';
                echo esc_url($install_link);
                ?>
            </div>
        </div>
    </div>

</div>

<?php
function mo_mmp_show_scan_details($detailreport, $result, $ignorefiles, $last_scan){
	$record = $result[0];
	$repo_status_code = MoMmpConstants::$repo_status_code;
?>
	<div style="float: left;"><b>Total files scanned:</b> <?php echo esc_attr($last_scan); ?><br><b>Malicious files found:</b> <?php echo count($detailreport); ?></div>
	<div style=float:right><b>Scan Time :</b> <?php echo date("M j, Y, g:i:s a",esc_attr($record->start_timestamp)); ?><br><b>Completion Time :</b> <?php echo date("M j, Y, g:i:s a",esc_attr($record->completed_timestamp)); ?></div><br><br><hr><br>
	<div width="100%">
	<?php
	$malwarecount = 0;
	foreach($detailreport as $report){
		$issues = unserialize($report->report);
		if(isset($issues['scan'])){
			$malwarecount++;
			break;
		}
	}
	if($malwarecount == 0){
		echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: green; font-size: medium'>No critical issues found.</b>";
		echo "<input id='malware_button' class='mmp_green' type='button' name='malware_button' value='Show less' style='float:right'></div>";
	}else{
		echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: red; font-size: medium'>Found critical issues</b>";
		echo "<input id='malware_button' class='mmp_green' type='button' name='malware_button' value='Show less' style='float:right'></div>";
	}
		echo "<hr>";
		echo "<div id='malware_content' style='display:block'>";
		
		?>
		<table id="malware_table" style="text-align:center" class="display" cellspacing="0" width="100%">
		<thead><tr><th >File Name</th><th style="width: 25%">Malware Details<a href="admin.php?page=mo_mmp_upgrade"> <b style="color: orange; font-size: medium;">[Premium]</b> </a></th></tr></thead>
		<tbody>
		<?php
		foreach($detailreport as $report){
			$issues = unserialize($report->report);
			$filename = $report->filename;
			
			if(isset($issues['scan'])){
				echo "<tr><td style=text-align:center>".esc_attr($filename)."</td><td>";
				$t= htmlspecialchars($issues['scan']);
				echo '<div><span class="issue mmp_point">Details</span><div class="issuecontent hidden" data-content=""></div></div>';
			}
			echo "</div>";
		}
		?>
			</tbody>
		</table>
		<?php
		echo "</div>";
		echo "</div>";

		$repochekcount = 0;
		$net_connectivity = $record->net_connection;
		if($record->repo_issues < 0){
			echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: orange; font-size: medium'>".esc_attr($repo_status_code[$record->repo_issues])."</b>";
			echo "<input id='repo_button' class='mmp_green' type='button' name='repo_button' value='Show more' style='float:right'></div>";
		}else{
			foreach($detailreport as $report){
				$issues = unserialize($report->report);
				if(isset($issues['repo'])){
					$repochekcount++;
					break;
				}
			}
			if($repochekcount==0){
				echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: green; font-size: medium'>No Repository check warning found</b>";
				echo "<input id='repo_button' class='mmp_green' type='button' name='repo_button' value='Show more' style='float:right'></div>";
			}else{
				if($net_connectivity){
					echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: orange; font-size: medium'>Found Repository check Warnings(incomplete due to Internet issues)</b>";
				}else{
					echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: orange; font-size: medium'>Found Repository check Warnings in your Site</b>";
				}
				
				echo "<input id='repo_button' class='mmp_green' type='button' name='repo_button' value='Show more' style='float:right'></div>";
			}
		}
		
		echo "<hr>";
		echo "<div id='repo_content' style='display:none'>";
		?>
		<table id="repo_table" style="text-align:center" class="display" cellspacing="0" width="100%">
		<thead><tr><th>File Name</th><th>Repository Comparison Details</th></tr></thead>
		<tbody>
		<?php
		foreach($detailreport as $report){
			$issues = unserialize($report->report);
			$filename = $report->filename;

			if(isset($issues['repo'])){
				echo "<tr><td style=text-align:center>".esc_attr($filename)."</td><td>";
				$t= htmlspecialchars($issues['repo']['exist']);
				echo '<div><span class="issue mmp_point" onclick="mo_wpns_show_details(this)">Details</span><div class="issuecontent hidden" data-content="'.esc_attr($t).'"></div></div>';
			} 
			echo "</div>";			
		}
		?>
			</tbody>
		</table>
		<?php
		echo "</div>";
		echo "</div>";

		$maliciouslinkcount = 0;
		foreach($detailreport as $report){
			$issues = unserialize($report->report);
			if(isset($issues['extl'])){
				$maliciouslinkcount++;
				break;
			}
		}
		if($maliciouslinkcount == 0){
			echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: green; font-size: medium'>No malicious links found</b>";
			echo "<input id='extl_button' class='mmp_green' type='button' name='extl_button' value='Show more' style='float:right'></div>";
		}else{
			echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: orange; font-size: medium'>Found External links in your Site</b>";
			echo "<input id='extl_button' class='mmp_green' type='button' name='extl_button' value='Show more' style='float:right'></div>";
		}
		echo "<hr>";
		echo "<div id='extl_content' style='display:none'>";
		?>
		<table id="extl_table" style="text-align:center" class="display" cellspacing="0" width="100%">
		<thead><tr><th>File Name</th><th>External Link Details</th></tr></thead>
		<tbody>
		<?php
		foreach($detailreport as $report){
			$issues = unserialize($report->report);
			$filename = $report->filename;
			if(isset($issues['extl'])){
				echo "<tr><td style=text-align:center>".esc_attr($filename)."</td><td>";
				$t='';
				for ($i=0; $i <sizeof($issues['extl']) ; $i++) { 
					$t.= $issues['extl'][$i]['d'];
					$t.= " on line ".$issues['extl'][$i]['l']."<br>";
				}
				$t= htmlspecialchars($t);
				echo '<div><span class="issue mmp_point" onclick="mo_wpns_show_details(this)">Details</span><div class="issuecontent hidden" data-content="'.esc_attr($t).'"></div></div>';
			}
			echo "</div>";			
		}
		?>
			</tbody>
		</table>
		<?php
		echo "</div>";
		echo "</div>";

		$file_size_excess = get_site_option('mo2f_file_size_excess');
		$files_skipped = get_site_option('mo2f_files_skipped');
		$download_issue = $record->repo_key;

		if($file_size_excess == 0 && $files_skipped == 0 && is_null($download_issue)){
			echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: green; font-size: medium'>No files skipped during scan</b>";
			echo "<input id='skip_button' class='mmp_green' type='button' name='skip_button' value='Show more' style='float:right'></div>";
		}else{
			echo "<div style='margin: 5px 0; border: 1px solid; border-radius: 5px; padding: 10px'><div><b style='color: orange; font-size: medium'>Files skipped during scan</b>";
			echo "<input id='skip_button' class='mmp_green' type='button' name='skip_button' value='Show more' style='float:right'></div>";
		}
		echo "<hr>";
		echo "<div id='skip_content' style='display:none'>";
		?>
		<table id="skip_table" style="text-align:center" class="display" cellspacing="0" width="100%">
		<thead><tr><th>Reason for skipping</th><th>Details</th></tr></thead>
		<tbody>
		<?php
		if($file_size_excess){
			echo "<tr><td style=text-align:center>Files size more than the threshold</td><td>".esc_attr($file_size_excess)." such files found</td></tr>";
		}
		if($files_skipped){
			echo "<tr><td style=text-align:center>Images(png,jpg,jpeg), Compressed Files(zip,rar)</td><td>".esc_attr($files_skipped)." such files found</td></tr>";
		}
		if($download_issue){
			echo "<tr><td style=text-align:center>Issues in downloading from repository</td><td>";
			$length = strlen($download_issue);
			$download_issue = substr($download_issue, 0, $length-1);
			$download_issue_array = explode(";", $download_issue);
			$t='';
			for ($i=0; $i <sizeof($download_issue_array) ; $i++) { 
				$t.=$download_issue_array[$i]."<br>";
			}
			$t= htmlspecialchars($t);
			echo '<div><span class="issue mmp_point" onclick="mo_wpns_show_details(this)">Details</span><div class="issuecontent hidden" data-content="'.esc_attr($t).'"></div></div>';
		}
		?>
			</tbody>
		</table>
		<?php
		echo "</div>";
		echo "</div>";
	?>
	</div>
	<div id="myModal" class="mo_scan_modal">
	  <div class="mo_scan_modal-content">
		<span class="mo_scan_close">x</span>
		<div>
			<pre id="modalcontent"></pre>
		</div>
	  </div>
	</div>
<?php
}

function mo_mmp_show_scan_report($currenturl, $result){
	$mo_wpns_db_handler = new MoMmpDB();
	$i= sizeof($result)-1;
	if($i>=0){
		$j= get_site_option('mo_mmp_scans_done');
		while($j>0){
			$type= $result[$i]->scan_mode;
			if($type == 'Custom Scan'){
				$result[$i]->malware_count="-1";
			}else{
				break;
			}
			$i--;
			$j--;
		}
	}
?>
<table id="reports_table" style="text-align:center" class="display" cellspacing="0" width="100%">
<thead><tr><th>Scan Type</th><th>Scanned Folders</th><th>Status</th><th>Scan Time</th><th>Action</th></tr></thead>
<tbody>
	<?php 
	if(!empty($result)){
		foreach($result as $report){
			if(empty($report->scan_mode)){
				$report->scan_mode="Custom Scan";
			}
			$repo_count = $report->repo_issues >= 0 ? $report->repo_issues : 0;
			echo "<tr><td style=text-align:center>".esc_attr($report->scan_mode)."</td>";
			echo "<td style=text-align:center>";
			if(!empty($report->scanned_folders)){
				foreach(explode(";",$report->scanned_folders) as $folder){
					if(!empty($folder)){
						echo esc_attr($folder)."<br>";
					}
				}
			}
			echo "</td><td style=text-align:center>";
			echo "<span style=color:green id=scan_files>".esc_attr($report->scanned_files)." files scanned<br></span>";
			if($report->malware_count == '-1'){
				echo "<span style=color:red id=malicious_files> Scan again for better results.<br></span>";
			}else{
				echo "<span style=color:red id=malicious_files>".esc_attr($report->malware_count)." malware found<br></span>";
				if($report->repo_issues < 0){
					echo "<span style=color:orange id=malicious_files>Issues with repository check<br></span>";
				}
				echo "<span style=color:orange id=warning_files>".esc_attr(($repo_count+$report->malicious_links))." warnings found</span>";
			}
			echo "</td><td style=text-align:center id=start_time>".date("M j, Y, g:i:s a",esc_attr($report->start_timestamp))."</td>";
			echo "<td><a href='".add_query_arg( array('tab' => 'default', 'view' => esc_html($report->id)), esc_url($currenturl ))."'>View Details</a> <a href='".add_query_arg( array('tab' => 'default', 'delete' => esc_attr($report->id)), esc_url($currenturl ))."'>Delete</a></td>";
			echo "</tr>";
		
		}
	}
	 ?>
</tbody>
</table>

<?php
}
?>
<script>
	jQuery(document).ready(function() {
		jQuery('#reports_table').DataTable({
			<?php if(! isset($_GET['view'])){ ?>
				"order": [[ 3, "desc" ]]
			<?php }
			else{ ?>
				"order": [[ 2, "desc" ]]
			<?php } ?>
		});
		jQuery('#skip_table').DataTable({
				"order": [[ 1, "desc" ]]
		});
		jQuery('#extl_table').DataTable({
				"order": [[ 1, "desc" ]]
		});
		jQuery('#repo_table').DataTable({
				"order": [[ 1, "desc" ]]
		});
		jQuery('#malware_table').DataTable({
				"order": [[ 1, "desc" ]]
		});
		jQuery('input[name="skip_button"]').click(function(){
			var skip_value= document.getElementById("skip_button").value;
			if(skip_value == 'Show more'){
				document.getElementById('skip_content').style.display="block";
				document.getElementById("skip_button").value="Show less";
			}else{
				document.getElementById('skip_content').style.display="none";
				document.getElementById("skip_button").value="Show more";
			}
		});
		jQuery('input[name="extl_button"]').click(function(){
			var extl_value= document.getElementById("extl_button").value;
			if(extl_value == 'Show more'){
				document.getElementById('extl_content').style.display="block";
				document.getElementById("extl_button").value="Show less";
			}else{
				document.getElementById('extl_content').style.display="none";
				document.getElementById("extl_button").value="Show more";
			}
		});
		jQuery('input[name="repo_button"]').click(function(){
			var extl_value= document.getElementById("repo_button").value;
			if(extl_value == 'Show more'){
				document.getElementById('repo_content').style.display="block";
				document.getElementById("repo_button").value="Show less";
			}else{
				document.getElementById('repo_content').style.display="none";
				document.getElementById("repo_button").value="Show more";
			}
		});
		jQuery('input[name="malware_button"]').click(function(){
			var extl_value= document.getElementById("malware_button").value;
			if(extl_value == 'Show more'){
				document.getElementById('malware_content').style.display="block";
				document.getElementById("malware_button").value="Show less";
			}else{
				document.getElementById('malware_content').style.display="none";
				document.getElementById("malware_button").value="Show more";
			}
		});
	} );

	function mo_wpns_show_details(elem){
		var issuehtml = jQuery(elem).parent().find(".issuecontent").data("content");
		var modal = document.getElementById('myModal');
		var span = document.getElementsByClassName("mo_scan_close")[0];
		issuehtml = "<span class=mo_mmp_red style=white-space:initial >"+issuehtml+"</span>";
		jQuery("#modalcontent").html(issuehtml);
		modal.style.display = "block";
		span.onclick = function() {
			modal.style.display = "none";
		}			
		window.onclick = function(event) {
			if (event.target == modal) {
				modal.style.display = "none";
			}
		}
	}
</script>